/*
 * Decompiled with CFR 0.152.
 */
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class Host
extends JFrame
implements ActionListener {
    private JPanel hostPanel;
    private JSpinner playerSpinner;
    private JComboBox mapList;
    private JComboBox difficultyList;
    private JCheckBox deathmatchCheck;
    private JButton startGameButton;

    public static void main(String[] args) {
        new Host();
    }

    public Host() {
        this.setTitle("ZDoom Multiplayer");
        this.setSize(500, 175);
        this.setVisible(true);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.hostPanel = new JPanel();
        this.hostPanel.setLayout(new FlowLayout(0, 20, 15));
        JLabel numPlayers = new JLabel("Enter number of players.");
        this.hostPanel.add(numPlayers);
        this.playerSpinner = new JSpinner(new SpinnerNumberModel(2, 1, 8, 1));
        this.hostPanel.add(this.playerSpinner);
        JLabel mapNum = new JLabel("Enter map number.");
        this.hostPanel.add(mapNum);
        this.mapList = new JComboBox();
        int i = 1;
        while (i <= 32) {
            this.mapList.addItem(i);
            ++i;
        }
        this.mapList.addActionListener(this);
        this.hostPanel.add(this.mapList);
        JLabel difficulty = new JLabel("Enter difficulty level.");
        this.hostPanel.add(difficulty);
        this.difficultyList = new JComboBox();
        this.difficultyList.addItem("I'm too young to die");
        this.difficultyList.addItem("Hey, not too rough");
        this.difficultyList.addItem("Hurt me plenty");
        this.difficultyList.addItem("Ultra-Violence");
        this.difficultyList.addItem("Nightmare!");
        this.difficultyList.addActionListener(this);
        this.hostPanel.add(this.difficultyList);
        JLabel deathmatch = new JLabel("Deathmatch?");
        this.hostPanel.add(deathmatch);
        this.deathmatchCheck = new JCheckBox();
        this.deathmatchCheck.addActionListener(this);
        this.hostPanel.add(this.deathmatchCheck);
        this.startGameButton = new JButton("Start Game");
        this.startGameButton.addActionListener(this);
        this.hostPanel.add(this.startGameButton);
        this.add(this.hostPanel);
        this.hostPanel.setVisible(true);
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.startGameButton) {
            File hostFile = new File("host.bat");
            if (!hostFile.exists()) {
                try {
                    hostFile.createNewFile();
                }
                catch (Exception exception) {
                    System.exit(0);
                }
            }
            PrintWriter writer = Host.openWriter(hostFile);
            String ipAddress = "ERROR IN FINDING IP";
            try {
                InetAddress addr = InetAddress.getLocalHost();
                ipAddress = addr.getHostAddress();
            }
            catch (Exception addr) {
                // empty catch block
            }
            String line = "@echo Host IP address is ";
            line = String.valueOf(line) + ipAddress;
            writer.println(line);
            writer.println("@echo Make sure the people joining know the address.");
            writer.println("@pause");
            line = "@zdoom -host ";
            line = String.valueOf(line) + this.playerSpinner.getValue();
            if (this.deathmatchCheck.isSelected()) {
                line = String.valueOf(line) + " -altdeath -nomonsters";
            }
            line = String.valueOf(line) + " -warp ";
            line = String.valueOf(line) + this.mapList.getSelectedItem();
            line = String.valueOf(line) + " -skill ";
            String diffString = (String)this.difficultyList.getSelectedItem();
            line = diffString.equals("Nightmare!") ? String.valueOf(line) + "5" : (diffString.equals("Ultra-Violence") ? String.valueOf(line) + "4" : (diffString.equals("Hurt me plenty") ? String.valueOf(line) + "3" : (diffString.equals("Hey, not too rough") ? String.valueOf(line) + "2" : String.valueOf(line) + "1")));
            writer.println(line);
            writer.println("@exit");
            writer.close();
            try {
                Runtime.getRuntime().exec("cmd /c start host.bat");
                System.exit(0);
            }
            catch (Exception except) {
                System.exit(0);
            }
        }
    }

    public static PrintWriter openWriter(File file) {
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            return writer;
        }
        catch (IOException e) {
            System.exit(0);
            return null;
        }
    }
}

