#include <fstream.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>
#include <new.h>
#include "utils.h"
#include "menu.h"
#include "video.h"
#include "defs.h"
#include "kb.h"
#include "clock.h"
#include "chdir.h"
#include "panel.h"

struct HEADER {
  char ID[5];
  char temp[3];
  unsigned offs1;
  unsigned offs2;
} h;

class TDoomHack {
  private:
    TMenu *menu;
    ifstream wad;
    char wadname[13];
    TPanel *p1, *p2, *active;
    WadStruct *beg;
    void Free();
    void FixSizes();
  public:
    TDoomHack(char *);
    ~TDoomHack();
    void DrawScreen();
    void RestoreScreen();
    void Run();
    void About();
    void Open(char *filename);
    void Rebuild();
    int Exit();
};

TDoomHack::TDoomHack(char *filename)
{
  strcpy(wadname, "DOOM2.WAD");
  set_rgb(1, 0, 0, 32);
  HideCursor();
  menu = new TMenu(0,
    NewMenuItem("~F~ile",
      NewSubMenuItem("Open WAD          F3", 2,
      NewSubMenuItem("Rebuild WAD...    F2", 18,
      NewSubMenuItem("View file         F4", 19,
      NewSubMenuItem("Extract...        F5", 20,
      NewSubMenuItem("Quit           Alt-X", 1, 0))))),
    NewMenuItem("~E~dit",
      NewSubMenuItem("Delete item      Del", 5,
      NewSubMenuItem("Create item      Ins", 6,
      NewSubMenuItem("Clear item       C", 8, 0))),
    NewMenuItem("~H~elp",
      NewSubMenuItem("~A~bout", 13, 0), 0))));
  DrawScreen();
  active = NULL;
  p1 = NULL;
  p2 = NULL;
  beg = NULL;
  About();
  Open(filename);
}

TDoomHack::~TDoomHack()
{
  Free();
  RestoreScreen();
  set_rgb(1, 0, 0, 40);
  delete p2;
  delete p1;
  delete menu;
  wad.close();
}

void TDoomHack::DrawScreen()
{
  fill(0, 1, 80, 23, '', BACK_COLOR);
  fill(0, 24, 80, 1, ' ', MENU_COLOR);
  out_hotstring(1, 24, "~F10~ Menu   ~Alt-X~ Quit", MENU_COLOR, HOT_COLOR);
}

void TDoomHack::RestoreScreen()
{
  gotoxy(1, 1);
  fill(0, 0, 80, 25, ' ', 0x07);
}

void TDoomHack::Free()
{
  WadStruct *t = beg;
  while (t != NULL)
  {
    beg = t -> next;
    delete t;
    t = beg;
  }
}

void TDoomHack::FixSizes()
{
  WadStruct *t = beg, *p;

  while (t != NULL)
  {
    if (t -> offs && t -> size)
    {
      p = t -> next;
      while (!p -> offs && (p -> next != NULL)) p = p -> next;
      if ((p != NULL) && p -> offs)
        t -> size = p -> offs - t -> offs;
    }
    t = t -> next;
  }
}

void TDoomHack::Open(char *filename)
{
  if (!*filename)
  {
    if (InputBox("Open WAD file", "Enter file name:", 13, wadname, wadname))
      return;
  }
  else
    strcpy(wadname, filename);
  wad.close();
  wad.open(wadname, ios::binary);
  if (!wad)
  {
    MessageBox("Error", "Unable to open file\n", 0);
    return;
  }
  wad.read((unsigned char *)&h, 12);
  if (strstr(h.ID, "IWAD") == NULL)
  {
    MessageBox("Error", "\"IWADM\" magic not found\n", 0);
    wad.close();
    return;
  }
  wad.seekg((long)h.offs2 * 0x10000 + h.offs1, ios::beg);

  if (p1 != NULL) delete p1;
  if (p2 != NULL) delete p2;
  if (active != NULL) beg = active -> beg;
  Free();

  WadStruct *p = new WadStruct, *end = NULL;
  beg = NULL;
  wad.read((unsigned char *)p, 16);

  while (wad)
  {
    p -> name[8] = 0;
    if (p -> name == strstr(p -> name, "MAP") && (!p -> size));
    else if (strstr(p -> name, "_START") != NULL && (!p -> size));
    else if (strstr(p -> name, "_END") != NULL && (!p -> size));
    else
    {
      for (int i = 0; i < strlen(p -> name); i++)
        p -> name[i] = tolower(p -> name[i]);
    }
    p -> next = NULL;
    if (beg == NULL)
      beg = p;
    else
      end -> next = p;
    p -> prev = end;
    end = p;
    p = new WadStruct;
    wad.read((unsigned char *)p, 16);
  }

  delete p;
  wad.close();
  wad.open(wadname, ios::binary);

  FixSizes();
  p1 = new TPanel(0, 1, beg);
  p1 -> SetActive();
  active = p1;
  p2 = new TPanel(40, 1, beg);
}

void TDoomHack::Rebuild()
{
  ofstream out;
  char *buf = new char[512];
  char filename[20];
  strcpy(filename, wadname);

  if (InputBox("Rebuild WAD file", "Enter file name:", 13, filename, filename))
    return;

  out.open(filename, ios::binary);
  if (!out)
  {
    MessageBox("Error", "Unable to create file\n", 0);
    return;
  }
  out.write((unsigned char *)&h, 12);
  if (active != NULL) beg = active -> beg;
  WadStruct *p = beg;

  while (p)
  {
    char s[20] = "Adding ";
    strcat(s, p -> name);
    fill(59, 24, 20, 1, ' ', MENU_COLOR);
    out_string(59, 24, s, MENU_COLOR);
    long o = out.tellp();
    if (p -> size)
    {
      wad.seekg(p -> offs, ios::beg);
      for (int i = 0; i < p -> size / 512; i++)
      {
        wad.read(buf, 512);
        out.write(buf, 512);
      }
      if (p -> size % 512)
      {
        wad.read(buf, p -> size % 512);
        out.write(buf, p -> size % 512);
      }
    }
    if (p -> offs) p -> offs = o;
    UpdateClock();
    p = p -> next;
    if (kbhit()) break;
  }

  delete buf;
  fill(59, 24, 20, 1, ' ', MENU_COLOR);
  p = beg;
  h.offs1 = out.tellp() % 0x10000;
  h.offs2 = out.tellp() / 0x10000;

  while (p)
  {
    int i = 0;
    char s[10];
    strcpy(s, p -> name);
    for (; i < strlen(s); i++)
      s[i] = toupper(s[i]);
    out.write((unsigned char *)p, 8);
    out.write(s, 8);
    p = p -> next;
  }
  out.seekp(0, ios::beg);
  out.write((unsigned char *)&h, 12);

  out.close();

  active -> DrawList();
  active -> SetActive();
  MessageBox("Information", "Rebuilding complete\n", 0);
}

void TDoomHack::Run()
{
  char key, old_key;
  int command = 0, i;
  long offs;

  do
  {
    command = 0;

    if (kbhit())
    {
      key = getch();

      if (old_key == 0)
      switch (key)
      {
        case 68: command = menu -> Run(); break;
        case 59: About(); break;
        case 61: command = 2; break;
        case 60: command = 18; break;
        case 62: command = 19; break;
        case 63: command = 20; break;
        case 45: command = 1; break;
        case 82: command = 6; break;
        case 83: command = 5; break;
        default: active -> Handle(0, key);
      }
      else
      switch (key)
      {
        case 'c':
        case 'C': command = 8; break;
        case 9: if (active == p1)
                {
                  p1 -> SetNotActive();
                  active = p2;
                  p2 -> SetActive();
                }
                else
                {
                  p2 -> SetNotActive();
                  active = p1;
                  p1 -> SetActive();
                } break;
        default: active -> Handle(key, 0);
      }

      switch (command)
      {
        case  1: if (!Exit()) command = 0; break;
        case  2: Open(""); break;
        case  5: active -> Del(); break;
        case  6: active -> Insert(); break;
        case  8: active -> Clear(); break;
        case 18: Rebuild(); break;
        case 19: active -> View(wadname); break;
        case 20: active -> Extract(wadname); break;
        case 13: About(); break;
      }

      if (old_key != 0)
      {
      }
      else
      {
      }
    }

    UpdateClock();
    old_key = key;

  } while (command != 1);
}

void TDoomHack::About()
{
  MessageBox("About", "DoomHack utility.\nCopyright (c) 1999 MATI Inc.\n", 0);
}

int TDoomHack::Exit()
{
  return !MessageBox("Warning", "Are you really\nwant to quit?!\n", 1);
}

void my_handler()
{
  gotoxy(1, 1);
  fill(0, 0, 80, 25, ' ', 0x07);
  cout << "Error: not enough memory\n";
  exit(1);
}

void main(int argc, char *argv[])
{
  set_new_handler(my_handler);
  TDoomHack *t;

  if (argc > 1)
    t = new TDoomHack(argv[1]);
  else
    t = new TDoomHack("");

  t -> Run();
  delete t;
}
