#ifndef _MOUSE_H_
#define _MOUSE_H_
#include <stdio.h>

#define MOUSE_MOVE_MASK        0x01
#define MOUSE_LBUTTON_PRESS    0x02
#define MOUSE_LBUTTON_RELEASE  0x04
#define MOUSE_RBUTTON_PRESS    0x08
#define MOUSE_RBUTTON_RELEASE  0x10
#define MOUSE_MBUTTON_PRESS    0x20
#define MOUSE_MBUTTON_RELEASE  0x40
#define MOUSE_ALL_EVENTS       0x7F

struct CursorShape
{
  unsigned AndMask[16];
  unsigned XorMask[16];
  int hot_x, hot_y;
};

typedef (*MouseHandler)(int, int, int, int);

static MouseHandler CurHandler = NULL;

int  MouseReset(int &);
void MouseShow();
void MouseHide();
void MouseRead(int &, int & ,int &);
void MouseSetPos(int, int);
void MouseGetPressedButtons(int, int &, int &, int &, int &);
void MouseGetReleasedButtons(int, int &, int &, int &, int &);
void MouseSetXRange(int, int);
void MouseSetYRange(int, int);
void SetMouseShape(CursorShape &);
void SetMouseCursor(int, int, int);
void ReadMouseCount(int &, int &);
void SetMouseHandler(MouseHandler, int);
void RemoveMouseHandler();
void SetMikkiPerPixel(int, int);
void SetHideRegion(int, int, int, int);
void SetDoubleSpeed(int);
void SetMouseSensitive(int, int, int);
void GetMouseSensitive(int &, int &, int &);
void SetInterruptFreq(int);
void GetMouseInfo(int &, unsigned char &);

int MouseReset(int &buttons)
{
  asm
  {
      xor    ax,  ax
      int    33h
  }
  buttons = _BX;
  return (_AX != 0xFFFF);
}

void MouseShow()
{
  asm
  {
      mov    ax,  1
      int    33h
  }
}

void MouseHide()
{
  asm
  {
      mov    ax,  2
      int    33h
  }
}

void MouseRead(int &x, int &y, int &b)
{
  int x_, y_, b_;
  asm
  {
      mov    ax,  3
      int    33h
      mov    x_,  cx
      mov    y_,  dx
      mov    b_,  bx
  }
  x = x_;
  y = y_;
  b = b_;
}

void MouseSetPos(int x, int y)
{
  asm
  {
      mov    cx,  x
      mov    dx,  y
      mov    ax,  4
      int    33h
  }
}

void MouseGetPressedButtons(int button, int &buttons, int &count, int &x, int &y)
{
  asm
  {
      mov    ax,  5
      mov    bx,  button
      int    33h
      mov    buttons,  ax
      mov    count,  bx
      mov    x,  cx
      mov    y,  dx
  }
}

void MouseGetReleasedButtons(int button, int &buttons, int &count, int &x, int &y)
{
  asm
  {
      mov    ax,  6
      mov    bx,  button
      int    33h
      mov    buttons,  ax
      mov    count,  bx
      mov    x,  cx
      mov    y,  dx
  }
}

void MouseSetXRange(int x_min, int x_max)
{
  asm
  {
      mov    ax,  7
      mov    cx,  x_min
      mov    dx,  x_max
      int    33h
  }
}

void MouseSetYRange(int y_min, int y_max)
{
  asm
  {
      mov    ax,  8
      mov    cx,  y_min
      mov    dx,  y_max
      int    33h
  }
}

void SetMouseShape(CursorShape &shape)
{
  asm
  {
      push   es
      push   di
      les    di, dword ptr shape
      mov    bx, shape.hot_x
      mov    cx, shape.hot_y
      mov    dx, di
      mov    ax, 9
      int    33h
  }
}

void SetMouseCursor(int mode, int and_mask, int or_mask)
{
  asm
  {
      mov    ax,  0Ah
      mov    bx,  mode
      mov    cx,  and_mask
      mov    dx,  or_mask
      int    33h
  }
}

void ReadMouseCount(int &dx_, int &dy)
{
  int x, y;
  asm
  {
      mov    ax,  0Bh
      int    33h
      mov    x,  cx
      mov    y,  dx
  }
  dx_ = x;
  dy = y;
}

static void far MouseStub()
{
  asm
  {
      push   ds
      push   ax
      mov    ax,  seg CurHandler
      mov    ds,  ax
      pop    ax
      push   dx
      push   cx
      push   bx
      push   ax
      call   CurHandler
      add    sp,  8
      pop    ds
  }
}

void SetMouseHandler(MouseHandler handler, int mask)
{
  void far *p = MouseStub;
  CurHandler = handler;
  asm
  {
      push   es
      mov    ax,  0Ch
      mov    cx,  mask
      les    dx,  p
      int    33h
      pop    es
  }
}

void RemoveMouseHandler()
{
  CurHandler =  NULL;
  asm
  {
      mov    ax,  0Ch
      xor    cx,  cx
      int    33h
  }
}

void SetMikkiPerPixel(int mikki_x, int mikki_y)
{
  asm
  {
      mov    ah,  0Fh
      mov    cx,  mikki_x
      mov    dx,  mikki_y
      int    33h
  }
}

void SetHideRegion(int x1, int y1, int x2, int y2)
{
  asm
  {
      mov    ax,  10h
      mov    cx,  x1
      mov    dx,  y1
      mov    si,  x2
      mov    di,  y2
      int         33h
  }
}

void SetDoubleSpeed(int speed)
{
  asm
  {
      mov    ax,  13h
      mov    dx,  speed
      int    33h
  }
}

void SetMouseSensitive(int mikki_x, int mikki_y, int speed)
{
  asm
  {
      mov    ax,  1Ah
      mov    bx,  mikki_x
      mov    cx,  mikki_y
      mov    dx,  speed
  }
}

void GetMouseSensitive(int &mikki_x, int &mikki_y, int &speed)
{
  asm
  {
      mov    ax,  1Ch
      int    33h
      mov    mikki_x,  bx
      mov    mikki_y,  cx
      mov    speed,  dx
  }
}

void SetInterruptFreq(int flags)
{
  asm
  {
      mov    ax,  1Ch
      mov    bx,  flags
      int    33h
  }
}

void GetMouseInfo(int &version, unsigned char &irq_number)
{
  asm
  {
      mov    ax,  24h
      mov    version,  bx
      mov    irq_number,  cl
  }
}

#endif
