#ifndef _VIEW_H_
#define _VIEW_H_
#include <conio.h>
#include "video.h"
#include "utils.h"
#include "defs.h"

void ViewWindow(char *, long);

void ViewWindow(char *buf, long size)
{
  char *screen = new char[4000];
  int x = 0, y = 0;

  gettext(10, 5, 72, 21, screen);
  DrawFrame(10, 5, 60, 15, VIEW_COLOR);
  set_attr(12, 20, 60, 1, SHADOW_COLOR);
  set_attr(70, 6, 2, 15, SHADOW_COLOR);
  fill(11, 6, 58, 13, ' ', VIEW_COLOR);

  while ((y < 13) && (y * 58 + x < size))
  {
    out_char(11 + x, 6 + y, *(buf + y * 58 + x), VIEW_TEXT);
    x++;
    if (x > 57)
    {
      x = 0;
      y++;
    }
  }

  getch();
  puttext(10, 5, 72, 21, screen);
  delete screen;
}

#endif
