#ifndef _UTILS_H_
#define _UTILS_H_
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include "video.h"
#include "defs.h"
#include "edit.h"
#include "clock.h"

void ShowCursor();
void HideCursor();
int MessageBox(char *, char *, int);
int InputBox(char *, char *, int, char *, char *);
void DrawFrame(int, int, int, int, char);
void DrawFrame2(int, int, int, int, char);
void set_rgb(char, char, char, char);

void set_rgb(char c, char r, char g, char b)
{
  asm
  {
    mov dx, 3C8h
    mov al, c
    out dx, al
    inc dx
    mov al, r
    out dx, al
    mov al, g
    out dx, al
    mov al, b
    out dx, al
  }
}

void DrawFrame(int x, int y, int w, int h, char attr)
{
  fill(x + 1, y, w - 2, 1, '', attr);
  fill(x + 1, y + h - 1, w - 2, 1, '', attr);
  fill(x, y + 1, 1, h - 2, '', attr);
  fill(x + w - 1, y + 1, 1, h - 2, '', attr);
  out_char(x, y, '', attr);
  out_char(x + w - 1, y, '', attr);
  out_char(x, y + h - 1, '', attr);
  out_char(x + w - 1, y + h - 1, '', attr);
}

void DrawFrame2(int x, int y, int w, int h, char attr)
{
  fill(x + 1, y, w - 2, 1, '', attr);
  fill(x + 1, y + h - 1, w - 2, 1, '', attr);
  fill(x, y + 1, 1, h - 2, '', attr);
  fill(x + w - 1, y + 1, 1, h - 2, '', attr);
  out_char(x, y, '', attr);
  out_char(x + w - 1, y, '', attr);
  out_char(x, y + h - 1, '', attr);
  out_char(x + w - 1, y + h - 1, '', attr);
}

void DrawButton(int x, int y, char *caption, char attr)
{
  out_string(x, y, caption, attr);
  out_char(x + strlen(caption), y, '', MSG_TEXTCOLOR);
  for (int i = 0; i < strlen(caption); i++)
    out_char(x + i + 1, y + 1, '', MSG_TEXTCOLOR);
}

int MessageBox(char *title, char *message, int flags)
{
  char *t = message, key, *buf = new char[1000];
  int w = 0, h = 0, l = 0, res = 0, a1, a2;

  while (*t)
  {
    if (*t++ == '\n')
    {
      h++;
      if (l > w) w = l;
      l = 0;
    }
    l++;
  }

  h += 6;
  if (strlen(title) > w) w = strlen(title);
  w += 20;

  int x = 40 - w / 2, y = 12 - h / 2;

  gettext(x + 1, y + 1, x + w + 2, y + h + 1, buf);

  fill(x + 1, y, w - 2, 1, '', MSG_FRAMECOLOR);
  fill(x + 1, y + h - 1, w - 2, 1, '', MSG_FRAMECOLOR);
  fill(x, y + 1, 1, h - 2, '', MSG_FRAMECOLOR);
  fill(x + w - 1, y + 1, 1, h - 2, '', MSG_FRAMECOLOR);
  out_char(x, y, '', MSG_FRAMECOLOR);
  out_char(x + w - 1, y, '', MSG_FRAMECOLOR);
  out_char(x, y + h - 1, '', MSG_FRAMECOLOR);
  out_char(x + w - 1, y + h - 1, '', MSG_FRAMECOLOR);
  fill(x + 1, y + 1, w - 2, h - 2, ' ', MSG_TEXTCOLOR);

  out_char(39 - strlen(title) / 2, y, ' ', MSG_FRAMECOLOR);
  out_string(40 - strlen(title) / 2, y, title, MSG_FRAMECOLOR);
  out_char(40 - strlen(title) / 2 + strlen(title), y, ' ', MSG_FRAMECOLOR);

  set_attr(x + w, y + 1, 2, h, SHADOW_COLOR);
  set_attr(x + 2, y + h, w, 1, SHADOW_COLOR);

  t = new char[strlen(message) + 1];
  strcpy(t, message);
  int m = 0, y_ = y + 2;
  char *s = t;
  while (*t)
  {
    if (*t != '\n')
      m++;
    else
    {
      *t = 0;
      out_string(40 - m / 2, y_, s, MSG_TEXTCOLOR);
      y_++;
      m = 0;
      s = t + 1;
    }
    t++;
  }

  while (kbhit()) getch();
  key = 0;

  if (flags & 1)
  {
    DrawButton(31, y + h - 3, "  Yes  ", MSG_SELCOLOR);
    DrawButton(42, y + h - 3, "  No  ", MSG_UNSELCOLOR);
    do
    {
      if (kbhit())
      {
        key = getch();
        a1 = MSG_SELCOLOR;
        a2 = MSG_UNSELCOLOR;
        switch (key)
        {
          case 77: if (res < 1) res++; else res = 0; break;
          case 75: if (res > 0) res--; else res = 1; break;
        }
        if (res)
        {
          a2 = MSG_SELCOLOR;
          a1 = MSG_UNSELCOLOR;
        }
        DrawButton(31, y + h - 3, "  Yes  ", a1);
        DrawButton(42, y + h - 3, "  No  ", a2);
      }
      UpdateClock();
    } while ((key != 27) && (key != 13));
  }
  else
  {
    DrawButton(37, y + h - 3, "  Ok  ", MSG_SELCOLOR);
    do
    {
      if (kbhit()) key = getch();
      UpdateClock();
    } while ((key != 27) && (key != 13));
  }

  puttext(x + 1, y + 1, x + w + 2, y + h + 1, buf);
  delete buf;

  if (key == 13)
    return res;
  if (key == 27)
    return 1;

  return 0;
}

void ShowCursor()
{
  asm
  {
    mov    ah,  1
    mov    ch,  6
    mov    cl,  7
    int    10h
  }
}

void HideCursor()
{
  asm
  {
    mov    ah,  1
    mov    ch,  13
    xor    cl,  cl
    int    10h
  }
}

int InputBox(char *title, char *message, int max_len, char *text, char *dest)
{
  char key, *buf = new char[1000];
  int w = 40, h = 8, res;
  int x = 40 - w / 2, y = 12 - h / 2;

  ShowCursor();
  gettext(x + 1, y + 1, x + w + 2, y + h + 1, buf);

  fill(x + 1, y, w - 2, 1, '', MSG_FRAMECOLOR);
  fill(x + 1, y + h - 1, w - 2, 1, '', MSG_FRAMECOLOR);
  fill(x, y + 1, 1, h - 2, '', MSG_FRAMECOLOR);
  fill(x + w - 1, y + 1, 1, h - 2, '', MSG_FRAMECOLOR);
  out_char(x, y, '', MSG_FRAMECOLOR);
  out_char(x + w - 1, y, '', MSG_FRAMECOLOR);
  out_char(x, y + h - 1, '', MSG_FRAMECOLOR);
  out_char(x + w - 1, y + h - 1, '', MSG_FRAMECOLOR);
  fill(x + 1, y + 1, w - 2, h - 2, ' ', MSG_TEXTCOLOR);

  out_char(39 - strlen(title) / 2, y, ' ', MSG_FRAMECOLOR);
  out_string(40 - strlen(title) / 2, y, title, MSG_FRAMECOLOR);
  out_char(40 - strlen(title) / 2 + strlen(title), y, ' ', MSG_FRAMECOLOR);

  set_attr(x + w, y + 1, 2, h, SHADOW_COLOR);
  set_attr(x + 2, y + h, w, 1, SHADOW_COLOR);

  out_string(x + 3, y + 2, message, MSG_TEXTCOLOR);
  out_string(x + 3, y + h - 3, "Enter - Accept  Esc - Cancel", MSG_TEXTCOLOR);

  TEdit *edit = new TEdit(x + 3, y + 3, max_len, 34, text);
  res = edit -> EnterText();
  if (!res) edit -> GetText(dest);

  puttext(x + 1, y + 1, x + w + 2, y + h + 1, buf);
  HideCursor();
  delete buf;

  if (res) return 1;
  return 0;
}


#endif
