#ifndef _EDIT_H_
#define _EDIT_H_
#include <string.h>
#include <conio.h>
#include "defs.h"
#include "video.h"
#include "clock.h"

const char NON_VALID_CHARS[8] = {'\\', '/', '&', '?', '#', 0x0D, 0x1B, 0x00};

class TEdit {
    char *text;
    int x;
    int y;
    int w;
    int max_len;
    int pos;
    void Draw();
    void AddChar(char);
    void DeleteChar(int);
  public:
    TEdit(int, int, int, int, char *);
    ~TEdit();
    void GetText(char *);
    void Clear();
    void SetText(char *);
    int EnterText();
};

TEdit::TEdit(int x, int y, int max_len, int w, char *def_text)
{
  TEdit::x = x;
  TEdit::y = y;
  TEdit::w = w;
  TEdit::max_len = max_len;
  text = new char[max_len + 1];
  strcpy(text, def_text);
  pos = strlen(text);
  Draw();
}

TEdit::~TEdit()
{
  delete text;
}

void TEdit::GetText(char *dest)
{
  strcpy(dest, text);
}

void TEdit::Clear()
{
  *text = 0;
  pos = 0;
}

void TEdit::SetText(char *text)
{
  strcpy(TEdit::text, text);
}

void TEdit::Draw()
{
  char *t = text;
  int i = x;

  while (*t)
  {
    out_char(i++, y, *t++, EDIT_TEXTCOLOR);
  }

  fill(i, y, w + x - i, 1, ' ', EDIT_TEXTCOLOR);
  gotoxy(pos + 1 + x, y + 1);
}

void TEdit::AddChar(char c)
{
  char *t = text;
  while (*t++);
  for (int i = strlen(text); i > pos - 1; i--)
    *t-- = *(t - 1);
  *t = c;
  pos++;
}

void TEdit::DeleteChar(int pos)
{
  char *t = text;
  for (int i = 0; i < pos; i++, t++);
  while (*t)
  {
    *t++ = *(t + 1);
  }
}

int TEdit::EnterText()
{
  unsigned char key = 1, old_key = 1;

  do
  {
    if (kbhit())
    {
      key = getch();
      if (!old_key)
      {
        switch (key)
        {
          case 77: if (pos < strlen(text)) pos++; Draw(); break;
          case 75: if (pos > 0) pos--; Draw(); break;
          case 71: pos = 0; Draw(); break;
          case 79: pos = strlen(text); Draw(); break;
          case 83: if (pos < strlen(text)) DeleteChar(pos); Draw(); break;
        }
      }
      else if (key)
      {
        if (key == 8)
        {
          if (pos)
          {
            DeleteChar(pos - 1);
            pos--;
            Draw();
          }
        }
        else
        {
          int i;
          for (i = 0; i < strlen(NON_VALID_CHARS); i++)
            if (key == NON_VALID_CHARS[i]) break;
          if (i == strlen(NON_VALID_CHARS))
          {
            if (strlen(text) < max_len - 1)
              AddChar(key);
            Draw();
          }
        }
      }
    }
    UpdateClock();
    old_key = key;
  } while((key != 27) && (key != 13));

  if (key == 27) return 1;
  return 0;
}


#endif
