#ifndef _MENU_H_
#define _MENU_H_
#include <string.h>
#include <conio.h>
#include "mouse.h"
#include "video.h"
#include "utils.h"
#include "defs.h"

struct TSubMenuItem {
  char name[30];
  int command;
  TSubMenuItem *next;
};

struct TMenuItem {
  char name[20];
  int w, h;
  TSubMenuItem *submenu;
  TMenuItem *next;
};

int str_len(char *s)
{
  int len = 0;

  while (*s)
  {
    if (*s++ == '~') len--;
    len++;
  }

  return len;
}

TMenuItem *NewMenuItem(char *name, TSubMenuItem *submenu, TMenuItem *next)
{
  TMenuItem *t = new TMenuItem;
  TSubMenuItem *s;

  strcpy(t -> name, name);
  t -> submenu = submenu;
  t -> next = next;

  t -> w = 0;
  t -> h = 0;
  s = t -> submenu;

  while (s)
  {
    if (str_len(s -> name) > t -> w) t -> w = str_len(s -> name);
    t -> h++;
    s = s -> next;
  }

  return t;
}

TSubMenuItem *NewSubMenuItem(char *name, int command, TSubMenuItem *next)
{
  TSubMenuItem *s = new TSubMenuItem;

  strcpy(s -> name, name);
  s -> command = command;
  s -> next = next;

  return s;
}

class TMenu {
    void DrawMainMenu(int selected);
    void DrawSubMenu(TMenuItem *start, int selected, int first);
    TMenuItem *menu;
    int y;
    int sub_pos;
    int num_items;
    int command;
    int DoSubMenu(int submenu);
    char *buffer;
  public:
    TMenu(int y, TMenuItem *menu);
    ~TMenu();
    int Run();
};

TMenu::TMenu(int y, TMenuItem *menu)
{
  TMenu::menu = menu;
  TMenu::y = y;
  TMenuItem *t = menu;
  num_items = 0;
  buffer = new char[1000];

  while (t)
  {
    num_items++;
    t = t -> next;
  }

  DrawMainMenu(-1);
}

TMenu::~TMenu()
{
  delete buffer;
}

void TMenu::DrawMainMenu(int selected)
{
  TMenuItem *t = menu;
  int i = 1, n = 0, attr1, attr2;

  out_char(i - 1, y, ' ', MENU_COLOR);
  while (t)
  {
    if (n++ == selected)
    {
      attr1 = SEL_MENU_COLOR;
      attr2 = SEL_HOT_COLOR;
      sub_pos = i;
    }
    else
    {
      attr1 = MENU_COLOR;
      attr2 = HOT_COLOR;
    }
    out_char(i++, y, ' ', attr1);
    out_hotstring(i, y, t -> name, attr1, attr2);
    i += str_len(t -> name);
    out_char(i++, y, ' ', attr1);
    t = t -> next;
  }
  fill(i, y, 70 - i, 1, ' ', MENU_COLOR);
}

void TMenu::DrawSubMenu(TMenuItem *start, int selected, int first)
{
  TSubMenuItem *s = start -> submenu;
  int i, n = 0, attr1, attr2;

  if (sub_pos + start -> w > 69) sub_pos = 69 - start -> w;

  if (first)
  {
    fill(sub_pos + 1, y + 1, start -> w + 2, 1, '', MENU_COLOR);
    fill(sub_pos + 1, y + 2 + start -> h, start -> w + 2, 1, '', MENU_COLOR);
    fill(sub_pos, y + 2, 1, start -> h, '', MENU_COLOR);
    fill(sub_pos + start -> w + 3, y + 2, 1, start -> h, '', MENU_COLOR);
    fill(sub_pos - 1, y + 1, 1, start -> h + 2, ' ', MENU_COLOR);
    fill(sub_pos + start -> w + 4, y + 1, 1, start -> h + 2, ' ', MENU_COLOR);
    out_char(sub_pos, y + 1, '', MENU_COLOR);
    out_char(sub_pos + start -> w + 3, y + 1, '', MENU_COLOR);
    out_char(sub_pos, y + 2 + start -> h, '', MENU_COLOR);
    out_char(sub_pos + start -> w + 3, y + 2 + start -> h, '', MENU_COLOR);
    set_attr(sub_pos + start -> w + 5, y + 2, 2, start -> h + 2, SHADOW_COLOR);
    set_attr(sub_pos + 1, y + 3 + start -> h, start -> w + 6, 1, SHADOW_COLOR);
  }

  while (s)
  {
    i = sub_pos + 1;
    if (n == selected)
    {
      attr1 = SEL_MENU_COLOR;
      attr2 = SEL_HOT_COLOR;
    }
    else
    {
      attr1 = MENU_COLOR;
      attr2 = HOT_COLOR;
    }
    out_char(i++, y + 2 + n, ' ', attr1);
    out_hotstring(i, y + 2 + n, s -> name, attr1, attr2);
    i += str_len(s -> name);
    fill(i, y + 2 + n, start -> w - str_len(s -> name) + 1, 1, ' ', attr1);
    n++;
    s = s -> next;
  }
}

int TMenu::DoSubMenu(int submenu)
{
  TMenuItem *t = menu;
  TSubMenuItem *s;
  int n = 0, old_n = 0, status = -1;
  char key;

  for (int i = 0; i < submenu; i++)
    t = t -> next;

  if (!t -> submenu) return 0;
  s = t -> submenu;

  gettext(sub_pos, y + 2, t -> w + 8 + sub_pos, y + t -> h + 4, buffer);
  DrawSubMenu(t, n, 1);

  do
  {
    if (kbhit())
    {
      key = getch();
      switch (key)
      {
        case 80: if (n < t -> h - 1) n++; else n = 0; break;
        case 72: if (n > 0) n--; else n = t -> h - 1; break;
        case 13: for (int j = 0; j < n; j++)
                   s = s -> next;
                 command = s -> command;
      }
      if ((key == 77) || (key == 75)) status = key;
    }
    if (n != old_n)
    {
      DrawSubMenu(t, n, 0);
    }
    old_n = n;
    UpdateClock();
  } while ((key != 27) && (key != 13) && (status != 77) && (status != 75));

  puttext(sub_pos, y + 2, t -> w + 8 + sub_pos, y + t -> h + 4, buffer);
  return status;
}

int TMenu::Run()
{
  int n = 0, old_n = 0, status = 0, Down = 0;
  char key;

  DrawMainMenu(n);
  command = 0;

  do
  {
    if (kbhit())
    {
      key = getch();
      switch (key)
      {
        case 77: if (n < num_items - 1) n++; else n = 0; break;
        case 75: if (n > 0) n--; else n = num_items - 1; break;
      }
      if ((key == 13) || (key == 80))
      {
        status = DoSubMenu(n);
        Down = 1;
      }
    }
    if (status == 77)
    {
      if (n < num_items - 1) n++; else n = 0;
      status = 0;
    }
    if (status == 75)
    {
      if (n > 0) n--; else n = num_items - 1;
      status = 0;
    }
    if (n != old_n)
    {
      DrawMainMenu(n);
      if (Down) status = DoSubMenu(n);
    }
    old_n = n;
    UpdateClock();
  } while ((key != 27) && (!command) && (status != -1));

  DrawMainMenu(-1);
  return command;
}

#endif
