#include <fstream.h>
#include <stdlib.h>
#include <string.h>
#include <new.h>
#include <dir.h>
#include <dos.h>

struct HEADER {
  char ID[5];
  char temp[3];
  unsigned offs1;
  unsigned offs2;
} h = {"IWADM",{11,0,0},0,0};

struct TList {
  unsigned long offs;
  unsigned long size;
  char     name[9];
  TList    *next;
} *beg = NULL, *end = NULL;


ofstream out("doom2.wad", ios::binary);
unsigned char *buf = new char[512];
long offs = 12;

void Add(long offs, long size, char *name)
{
  TList *t = new TList;

  for (int i = 0; i < 8; i++)
    t -> name[i] = 0;

  t -> offs = offs;
  t -> size = size;
  strcpy(t -> name, name);
  t -> next = NULL;

  if (beg == NULL)
    beg = t;
  else
    end -> next = t;
  end = t;
}

void FreeAll()
{
  TList *t = beg;

  while (t)
  {
    beg = t -> next;
    delete t;
    t = beg;
  }
}

void Write()
{
  ffblk ffblk;
  int done;

  done = findfirst("*.*", &ffblk, FA_ARCH);

  while (!done)
  {
    if (ffblk.ff_attrib == FA_ARCH)
    {
      cout << "Adding ";
      getcurdir(6, buf);
      strcat(buf, "\\");
      strcat(buf, ffblk.ff_name);
      strcat(buf, "...");
      cout << buf;
      Add(offs, ffblk.ff_fsize, ffblk.ff_name);
      ifstream in(ffblk.ff_name, ios::binary);
      for (int i = 0; i < ffblk.ff_fsize / 512; i++)
      {
        in.read(buf, 512);
        out.write(buf, in.gcount());
      }
      if (ffblk.ff_fsize % 512)
      {
        in.read(buf, ffblk.ff_fsize % 512);
        out.write(buf, in.gcount());
      }
      in.close();
      offs += ffblk.ff_fsize;
      cout << "Ok\n";
    }
    done = findnext(&ffblk);
  }

  done = findfirst("*.", &ffblk, FA_DIREC);

  while (!done)
  {
    if (ffblk.ff_attrib == FA_DIREC)
    if (strcmp(ffblk.ff_name, "."))
    if (strcmp(ffblk.ff_name, ".."))
    {
      if (strstr(ffblk.ff_name, "MAP") != NULL)
        Add(offs, 0, ffblk.ff_name);
      else
        Add(0, 0, ffblk.ff_name);
      chdir(ffblk.ff_name);
      cout << "Adding ";
      getcurdir(6, buf);
      cout << buf << "\n";
      Write();
      char *u = strstr(ffblk.ff_name, "_START");
      if (u != NULL)
      {
        ffblk.ff_name[u - ffblk.ff_name] = 0;
        strcat(ffblk.ff_name, "_END");
        Add(0, 0, ffblk.ff_name);
      }
    }
    done = findnext(&ffblk);
  }

  chdir("..");
}

void WriteList()
{
  TList *t = beg;

  while (t)
  {
    out.write((unsigned char *)t, 16);
    t = t -> next;
  }
}

void my_handler()
{
  cout << "Error: not enough memory\n";
  exit(1);
}

void main()
{
  set_new_handler(my_handler);

  if (!out)
  {
    cout << "Unable to create doom2.WAD\n";
    return;
  }

  chdir("DOOMDATA");
  out.write((unsigned char *)&h, 12);
  Write();
  h.offs1 = offs % 0x10000;
  h.offs2 = offs / 0x10000;
  WriteList();
  out.seekp(0, ios::beg);
  out.write((unsigned char *)&h, 12);
  chdir("..");
  FreeAll();

  out.close();
  delete buf;
}
